<?php
session_start();
include 'conexao.php'; // Inclua a conexão com o banco de dados
include 'verifica_login.php'; // Garante que esta inclusão é para verificar o login

// Verifica se o perfil é Subdirecção Administrativa
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO ADMINISTRATIVA') {
    header("Location: login.php");
    exit;
}

$nome = $_SESSION['usuario']['nome'] ?? 'Usuário';
$foto = $_SESSION['usuario']['foto'] ?? 'sem-foto.png';
$mensagem_upload = $_SESSION['mensagem_upload'] ?? '';

// Limpa a mensagem da sessão para que ela não seja exibida novamente após a atualização da página
unset($_SESSION['mensagem_upload']);

// LÓGICA PARA PROCESSAR O UPLOAD DA FOTO DE PERFIL
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['upload_foto'])) {
    if (isset($_FILES['nova_foto']) && $_FILES['nova_foto']['error'] === UPLOAD_ERR_OK) {
        $diretorio_destino = 'fotos/';
        // Verifica se o diretório de destino existe e é gravável
        if (!is_dir($diretorio_destino)) {
            mkdir($diretorio_destino, 0777, true); // Cria o diretório se não existir
        }
        if (!is_writable($diretorio_destino)) {
            $_SESSION['mensagem_upload'] = "❌ Erro do servidor: o diretório de fotos não tem permissão de escrita.";
            header("Location: painel_subdireccao_administrativa.php");
            exit;
        }

        $extensao = pathinfo($_FILES['nova_foto']['name'], PATHINFO_EXTENSION);
        // Gera um nome único para o arquivo para evitar colisões
        $foto_nova_nome = uniqid('perfil_') . '.' . $extensao;
        $caminho_completo = $diretorio_destino . $foto_nova_nome;

        if (move_uploaded_file($_FILES['nova_foto']['tmp_name'], $caminho_completo)) {
            // Atualiza o nome da foto no banco de dados
            $usuario_id = $_SESSION['usuario']['id'];
            $stmt = $conn->prepare("UPDATE usuarios SET foto = ? WHERE id = ?");
            $stmt->bind_param("si", $foto_nova_nome, $usuario_id);
            if ($stmt->execute()) {
                // Atualiza a variável de sessão para que a foto seja exibida imediatamente
                $_SESSION['usuario']['foto'] = $foto_nova_nome;
                $foto = $foto_nova_nome; // Atualiza a variável local
                $_SESSION['mensagem_upload'] = "✅ Foto de perfil atualizada com sucesso!";
            } else {
                $_SESSION['mensagem_upload'] = "❌ Erro ao atualizar o banco de dados.";
                // Remova a foto do servidor se o banco de dados falhar
                unlink($caminho_completo);
            }
            $stmt->close();
        } else {
            $_SESSION['mensagem_upload'] = "❌ Erro ao fazer o upload da foto.";
        }
    } else {
        $_SESSION['mensagem_upload'] = "⚠️ Por favor, selecione um arquivo de foto.";
    }
    // Redireciona para evitar reenvio do formulário
    header("Location: painel_subdireccao_administrativa.php");
    exit();
}

?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Painel Subdirecção Administrativa</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="js/chart.umd.js"></script>
    <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f4f6f9; }
        .sidebar { width: 260px; background: #001f3f; color: white; position: fixed; top: 0; bottom: 0; padding-top: 60px; z-index: 999; }
        .sidebar a { display: block; color: white; padding: 15px 20px; text-decoration: none; }
        .sidebar a:hover { background: #0056b3; }
        .topbar { position: fixed; left: 260px; right: 0; top: 0; height: 60px; background: #003366; color: white; display: flex; align-items: center; justify-content: space-between; padding: 0 20px; z-index: 1000; }
        .topbar .user-info { display: flex; align-items: center; gap: 10px; }
        .topbar img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid white; cursor: pointer; } /* Adicionado cursor pointer */
        .main-content { margin-left: 260px; margin-top: 60px; padding: 30px; }

        .graficos-container {
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
            margin-top: 40px;
        }

        .grafico-bloco {
            flex: 1;
            min-width: 300px;
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .grafico-bloco canvas {
            width: 100%;
            height: 300px;
        }

        /* Estilo da mensagem de sucesso/erro */
        .mensagem {
            margin-top: 10px;
            font-weight: bold;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        .mensagem.sucesso {
            color: #28a745;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }
        .mensagem.erro {
            color: #dc3545;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>

    <div class="sidebar">
        <a href="painel_financeiro.php"><i class="fas fa-file-invoice-dollar"></i> Painel Financeiro</a>
        <a href="remuneracao.php"><i class="fas fa-file-invoice-dollar"></i> Remuneração(pessoal eventual)</a>




        <a href="editar_dados_rh.php"><i class="fas fa-users"></i> Editar Dados dos Funcionários</a>


        <a href="declaracoes_rh_dinamico.php"><i class="fas fa-boxes"></i> Emitir Documentos dos Funcionários</a>
        <a href="relatorio_forca_trabalho.php"><i class="fas fa-receipt"></i> Força de trabalho</a>

        <a href=" necessidade_pessoal.php"><i class="fas fa-receipt"></i> Necessidade do Pessoal</a>

       
        <a href="documentos_recebidos.php"><i class="fas fa-folder-open"></i> Documentos Recebidos</a>
        <a href="enviar_documento.php"><i class="fas fa-upload"></i> Enviar Documento</a>
        <a href="alterar_senha.php"><i class="fas fa-upload"></i>Alterar Senha</a>
        <a href="propinas.php"><i class="fas fa-boxes"></i>Cadastro de Propinas/Comparticipação</a>
        <a href="historico_propinas.php"><i class="fas fa-boxes"></i>Histórico de Propinas/Comparticipação</a>
        <a href="login.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>

    <div class="topbar">
        <strong>PAINEL DA SUBDIRECÇÃO ADMINISTRATIVA | Subdirecção Administrativa</strong>
        <div class="user-info">
            <span><?= htmlspecialchars($nome) ?></span>
            <form action="" method="post" enctype="multipart/form-data" id="fotoUploadForm">
                <label for="nova_foto">
                    <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto do usuário" id="userPhoto">
                </label>
                <input type="file" name="nova_foto" id="nova_foto" style="display:none;" onchange="document.getElementById('fotoUploadForm').submit();">
                <input type="hidden" name="upload_foto" value="1"> </form>
        </div>
    </div>

    <div class="main-content">
        <h2>Bem-vindo(a), <?= htmlspecialchars($nome) ?>!</h2>
        <p>Selecione uma funcionalidade na barra lateral.</p>

        <?php if (!empty($mensagem_upload)): ?>
            <div class="mensagem <?= strpos($mensagem_upload, '✅') !== false ? 'sucesso' : 'erro' ?>">
                <?= $mensagem_upload ?>
            </div>
        <?php endif; ?>

        <div class="graficos-container" style="display: flex; flex-wrap: wrap; gap: 30px; justify-content: space-around; padding: 20px;">

            <div class="grafico-bloco" style="flex: 1 1 400px; max-width: 600px;">
                <h4 style="color:#003366;">Pagamento de Propinas por Classe</h4>
                <canvas id="graficoPropinas"></canvas>
            </div>

            <div class="grafico-bloco" style="flex: 1 1 400px; max-width: 600px;">
                <h4 style="color:#003366;">Fluxo Financeiro</h4>
                <canvas id="graficoEntradasSaidas"></canvas>
            </div>

        </div>
    </div>

<script>
    // Gráfico de pizza: Pagamento por classe
    const ctxPropinas = document.getElementById('graficoPropinas').getContext('2d');
    new Chart(ctxPropinas, {
        type: 'pie',
        data: {
            labels: ['10ª Classe', '11ª Classe', '12ª Classe', '13ª Classe'],
            datasets: [{
                label: 'Valor Pago (Kz)',
                data: [500000, 350000, 250000, 150000],
                backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545'],
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Gráfico de colunas: Entradas e Saídas
    const ctxFinanceiro = document.getElementById('graficoEntradasSaidas').getContext('2d');
    new Chart(ctxFinanceiro, {
        type: 'bar',
        data: {
            labels: ['Janeiro', 'Fevereiro', 'Março', 'Abril'],
            datasets: [
                {
                    label: 'Entradas (Kz)',
                    data: [400000, 350000, 420000, 380000],
                    backgroundColor: '#28a745'
                },
                {
                    label: 'Saídas (Kz)',
                    data: [250000, 200000, 300000, 270000],
                    backgroundColor: '#dc3545'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'top' }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    title: { display: true, text: 'Valores (Kz)' }
                }
            }
        }
    });
</script>
</body>
</html>